﻿abstract public class Contact
{
    protected string name;

    public Contact()
    {
        // instrukcje...
    }

    public abstract void GenerateReport();

    abstract public string Name
    {
        get;
        set;
    }
}

public class Customer : Contact
{
    string gender;
    decimal income;
    int numberOfVisits;

    public Customer()
    {
        // instrukcje
    }

    public override void GenerateReport()
    {
        // unikalny raport
    }

    public override string Name
    {
        get
        {
            numberOfVisits++;
            return name;
        }
        set
        {
            name = value;
            numberOfVisits = 0;
        }
    }
}

public class SiteOwner : Contact
{
    int siteHits;
    string mySite;

    public SiteOwner()
    {
        // instrukcje...
    }

    public override void GenerateReport()
    {
        // unikalny raport
    }

    public override string Name
    {
        get
        {
            siteHits++;
            return name;
        }
        set
        {
            name = value;
            siteHits = 0;
        }
    }
}
